<?php
require_once '../config.php';
verificarLogin();

$security = new Security($pdo);
$id = $_GET['id'];

// Verificar CSRF
if (!isset($_GET['csrf_token']) || !$security->verifyCSRFToken($_GET['csrf_token'])) {
    die("Token CSRF inválido!");
}

try {
    // Verificar se existem clientes usando este servidor DO USUÁRIO ATUAL
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM clientes WHERE servidor_id = ? AND usuario_id = ?");
    $stmt->execute([$id, $_SESSION['usuario_id']]);
    $total_clientes = $stmt->fetch()['total'];
    
    if ($total_clientes > 0) {
        header("Location: servidores.php?erro=1");
        exit();
    }
    
    // Registrar na auditoria antes de excluir
    $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['usuario_id'], 'excluir_servidor', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
    
    $stmt = $pdo->prepare("DELETE FROM servidores WHERE id = ? AND usuario_id = ?");
    $stmt->execute([$id, $_SESSION['usuario_id']]);
    
    header("Location: servidores.php?sucesso=1");
    exit();
} catch (PDOException $e) {
    header("Location: servidores.php?erro=1");
    exit();
}
?>